/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The FIRSTLONG operator returns the lowest supported LONG value
 * 
 * @author Erwin
 */
public final class FIRSTLONG implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] {};

	/**
	 * 
	 */
	private ScalarValueBuffer minLong;

	/**
	 * FIRSTLONG returns the lowest supported LONG value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return minLong == null ? minLong = DbmsLongImplementation.getValueBuffer(Long.MIN_VALUE) : minLong;
	}

	/**
	 * The operator takes no arguments
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
