/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * FLOOR returns the biggest integer that is smaller than or equal to the first argument and an exact multiple of the second. FLOOR(5,2) = 4 FLOOR(6,2) = 6 FLOOR(-5,2) = -6 FLOOR(-6,2) = -6 FLOOR(a,b) = FLOOR(a,-b)
 * 
 * @author Erwin
 */
public final class FLOOR_INT_INT implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * FLOOR returns the biggest integer that is smaller than or equal to the first argument and an exact multiple of the second. FLOOR(5,2) = 4 FLOOR(6,2) = 6 FLOOR(-5,2) = -6 FLOOR(-6,2) = -6 FLOOR(a,b) = FLOOR(a,-b)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ValueBuffer arg1 = args.get(0);
		int int1 = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) arg1);
		int int2 = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1));
		if (int2 == Integer.MIN_VALUE) {
			// special case because this value has no representable absolute value
			if (int1 >= 0) {
				return DbmsIntImplementation.getValueBuffer(0);
			} else {
				return DbmsIntImplementation.getValueBuffer(Integer.MIN_VALUE);
			}
		} else {
			int abs2 = Math.abs(int2);
			if (int1 >= 0) {
				return DbmsIntImplementation.getValueBuffer(int1 - (int1 % abs2));
			} else {
				if (int1 == Integer.MIN_VALUE) {
					if (int1 % abs2 == 0) {
						return arg1;
					} else {
						throw new NumericOverflowException();
					}
				} else {
					int mod = -int1 % abs2;
					if (mod == 0) {
						return arg1;
					} else {
						if (int1 + mod < Integer.MIN_VALUE + abs2) {
							throw new NumericOverflowException();
						}
						return DbmsIntImplementation.getValueBuffer(int1 + mod - abs2);
					}
				}
			}
		}
	}

	/**
	 * FLOOR takes two arguments, both of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
