/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * FLOOR returns the biggest integer that is smaller than or equal to the first argument and an exact multiple of the second. FLOOR(5,2) = 4 FLOOR(6,2) = 6 FLOOR(-5,2) = -6 FLOOR(-6,2) = -6 FLOOR(a,b) = FLOOR(a,-b)
 * 
 * @author Erwin
 */
public final class FLOOR_LONG_LONG implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG, TYPENAMES.LONG };

	/**
	 * FLOOR returns the biggest integer that is smaller than or equal to the first argument and an exact multiple of the second. FLOOR(5,2) = 4 FLOOR(6,2) = 6 FLOOR(-5,2) = -6 FLOOR(-6,2) = -6 FLOOR(a,b) = FLOOR(a,-b)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ValueBuffer arg1 = args.get(0);
		long lng1 = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) arg1);
		long lng2 = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(1));
		if (lng2 == Long.MIN_VALUE) {
			// special case because this value has no representable absolute value
			if (lng1 >= 0) {
				return DbmsLongImplementation.getValueBuffer(0);
			} else {
				return DbmsLongImplementation.getValueBuffer(Long.MIN_VALUE);
			}
		} else {
			long abs2 = Math.abs(lng2);
			if (lng1 > 0) {
				return DbmsLongImplementation.getValueBuffer(lng1 - (lng1 % abs2));
			} else {
				if (lng1 == Long.MIN_VALUE) {
					if (lng1 % abs2 == 0) {
						return arg1;
					} else {
						throw new NumericOverflowException();
					}
				} else {
					long mod = -lng1 % abs2;
					if (mod == 0) {
						return arg1;
					} else {
						if (lng1 + mod < Long.MIN_VALUE + abs2) {
							throw new NumericOverflowException();
						}
						return DbmsLongImplementation.getValueBuffer(lng1 + mod - abs2);
					}
				}
			}
		}
	}

	/**
	 * FLOOR takes two operands, both of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
