/*
 * Created on 15-jun-04
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * GT returns true if the first operand compares higher than the second, and false otherwise
 * 
 * @author Erwin Smout
 * @deprecated The use of the DECIMAL type is discouraged. The definition is rather awkward, the implementation rather poor, and the set of provided operators incomplete.
 */
public final class GT_DECIMAL_DECIMAL implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.DECIMAL, TYPENAMES.DECIMAL };

	/**
	 * GT returns true if the first operand compares higher than the second, and false otherwise
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ByteBuffer buffer_1 = ((ScalarValueBuffer) args.get(0)).getByteBuffer();
		ByteBuffer buffer_2 = ((ScalarValueBuffer) args.get(1)).getByteBuffer();

		long integerValue_1 = buffer_1.getLong();
		int digits_1 = buffer_1.get();
		int decimals_1 = buffer_1.get();

		long integerValue_2 = buffer_2.getLong();
		int digits_2 = buffer_2.get();
		int decimals_2 = buffer_2.get();

		// Case of different signs
		if (integerValue_1 < 0 && integerValue_2 >= 0) {
			return DbmsBooleanImplementation.falseValue;
		}
		if (integerValue_1 >= 0 && integerValue_2 < 0) {
			return DbmsBooleanImplementation.trueValue;
		}

		// Both values guaranteed to have equal sign (or zero value of course), test equality first
		if (integerValue_1 == integerValue_2 && digits_1 == digits_2) {
			return DbmsBooleanImplementation.falseValue;
		}

		// Both values guaranteed to be equal sign and unequal value, do away with negative values
		boolean invertResult;
		if (integerValue_1 < 0) {
			integerValue_1 = -integerValue_1;
			integerValue_2 = -integerValue_2;
			invertResult = true;
		} else {
			invertResult = false;
		}

		// Both values guaranteed to be zero-or-positive and unequal
		if (digits_1 > digits_2) {
			return invertResult ? DbmsBooleanImplementation.falseValue : DbmsBooleanImplementation.trueValue;
		}

		if (digits_1 < digits_2) {
			return invertResult ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
		}

		// Both values guaranteed to be zero-or-positive and unequal, but equal digits before the decimal point, integerValue itself
		// guaranteed to be unequal
		long integerPortion_1 = integerValue_1 / DbmsDecimalImplementation.powers_l[decimals_1];
		long integerPortion_2 = integerValue_2 / DbmsDecimalImplementation.powers_l[decimals_2];
		if (integerPortion_1 > integerPortion_2) {
			return invertResult ? DbmsBooleanImplementation.falseValue : DbmsBooleanImplementation.trueValue;
		}
		if (integerPortion_1 < integerPortion_2) {
			return invertResult ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
		}

		// Both values guaranteed to be zero-or-positive and unequal, but equal integer portion
		long decimalPortion_1 = integerValue_1 - integerPortion_1 * DbmsDecimalImplementation.powers_l[decimals_1];
		long decimalPortion_2 = integerValue_2 - integerPortion_2 * DbmsDecimalImplementation.powers_l[decimals_2];
		if (decimalPortion_1 > decimalPortion_2) {
			return invertResult ? DbmsBooleanImplementation.falseValue : DbmsBooleanImplementation.trueValue;
		}
		if (decimalPortion_1 < decimalPortion_2) {
			return invertResult ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
		}

		// Evevything equal but canonical value itself was not ????????????????
		throw new RuntimeException();
	}

	/**
	 * The DECIMAL ordering operator takes two operands, both of type DECIMAL
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
