/*
 * Created on 15-jun-04
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * GT returns true if the first operand compares higher than the second, and false otherwise
 * 
 * @author Erwin Smout
 */
public final class GT_FOO_FOO implements OperatorImplementation_V0104 {

	/**
	 * Comment for <code>argumentTypes</code>
	 */
	private static final String[] argumentTypes = new String[] { "FOO", "FOO" }; //$NON-NLS-1$//$NON-NLS-2$

	/**
	 * GT returns true if the first operand compares higher than the second, and false otherwise
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		final ByteBuffer byteBuffer1 = ((ScalarValueBuffer) args.get(0)).getByteBuffer();
		final ByteBuffer byteBuffer2 = ((ScalarValueBuffer) args.get(1)).getByteBuffer();
		double x1 = byteBuffer1.getDouble();
		double y1 = byteBuffer1.getDouble();
		double x2 = byteBuffer2.getDouble();
		double y2 = byteBuffer2.getDouble();
		if (x1 > x2 || (x1 == x2 && y1 > y2)) {
			return DbmsBooleanImplementation.trueValue;
		} else {
			return DbmsBooleanImplementation.falseValue;
		}
	}

	/**
	 * The FOO ordering operator takes two operands, both of type FOO
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
