/*
 * Created on 15-jun-04
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * GT returns true if the first operand compares higher than the second, and false otherwise
 */
public final class GT_INT_INT implements OperatorImplementation_V0104 {

	/**
	 * Comment for <code>argumentTypes</code>
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * GT returns true if the first operand compares higher than the second, and false otherwise
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		if (DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0)) > DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1))) {
			return DbmsBooleanImplementation.trueValue;
		} else {
			return DbmsBooleanImplementation.falseValue;
		}
	}

	/**
	 * The INT ordering operator takes two operands, both of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
