/**
 * 
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

/**
 * GreaterOrEqualOperatorImplementation is a generic implementation implementing the behaviour of a GE operator, for all types for which an ordering is defined in the form of a GT operator. It operates by invoking the LT operator implementation of the type,, and negating the result.
 * 
 * @author Erwin
 */
public final class GreaterOrEqualOperatorImplementation implements OperatorImplementation_V0104 {

	/**
	 * The implementation object for the reverse ordering operator (LT) corresponding to this greater-or-equal operator
	 */
	private LessThanOperatorImplementation lessThanOperatorImplementation;

	/**
	 * Creates the GreaterOrEqualOperatorImplementation
	 * 
	 * @param lessThanOperatorImplementation
	 *            The implementation object for the ordering operator (GT) corresponding to this less-than operator
	 */
	public GreaterOrEqualOperatorImplementation (LessThanOperatorImplementation lessThanOperatorImplementation) {
		this.lessThanOperatorImplementation = lessThanOperatorImplementation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#executeOperator(java.util.LinkedList)
	 */
	@Override
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsBooleanImplementation.getNegatedJavaBooleanBuffer((ScalarValueBuffer) lessThanOperatorImplementation.executeOperator(args));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#getArgumentTypeNames()
	 */
	@Override
	public String[] getArgumentTypeNames ( ) {
		return lessThanOperatorImplementation.getArgumentTypeNames();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#getReturnTypeName()
	 */
	@Override
	public String getReturnTypeName ( ) {
		return lessThanOperatorImplementation.getReturnTypeName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return lessThanOperatorImplementation.isDeterministic();
	}
}
