/*
 * Created on 11-okt-2006
 */
package be.SIRAPRISE.typeimplementations;

/**
 * An InvalidTypeValueException is thrown by a TypeImplementation or a PossRepImplementation method when it is presented some string that is not a valid representation of a value of the type involved.
 * 
 * @author Erwin Smout
 */
public class InvalidValueException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5409260683370304103L;

	/**
	 * Creates the Exception object, setting an error message
	 * 
	 * @param msg
	 *            The error message explaining the reason why the string value is invalid.
	 */
	public InvalidValueException (String msg) {
		super(msg);
	}

	/**
	 * Creates the Exception object, setting an error message and the causing exception
	 * 
	 * @param msg
	 *            The error message explaining the reason why the string value is invalid.
	 * @param e
	 *            The underlying cause of the InvalidValueException created.
	 */
	public InvalidValueException (String msg, Exception e) {
		super(msg, e);
	}
}
