/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The LASTDATE operator returns the highest supported DATE value
 * 
 * @author Erwin
 */
public final class LASTDATE implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] {};

	/**
	 * 
	 */
	private ValueBuffer maxDate;

	/**
	 * The operator returns the highest supported DATE value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return maxDate == null ? (maxDate = DbmsDateImplementation.getValueBuffer(9999, 12, 31)) : maxDate;
	}

	/**
	 * The operator takes no arguments
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is DATE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.DATE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
