/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The LASTINT operator returns the highest supported INT value
 * 
 * @author Erwin
 */
public final class LASTINT implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] {};

	/**
	 * 
	 */
	private ScalarValueBuffer maxInt;

	/**
	 * LASTINT returns the highest supported INT value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return maxInt == null ? maxInt = DbmsIntImplementation.getValueBuffer(Integer.MAX_VALUE) : maxInt;
	}

	/**
	 * LASTINT takes no arguments
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
