/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The LASTLONG operator returns the highest supported LONG value
 * 
 * @author Erwin
 */
public final class LASTLONG implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] {};

	/**
	 * 
	 */
	private ScalarValueBuffer maxLong;

	/**
	 * LASTLONG returns the highest supported LONG value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return maxLong == null ? maxLong = DbmsLongImplementation.getValueBuffer(Long.MAX_VALUE) : maxLong;
	}

	/**
	 * LASTLONG takes no arguments
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
