/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.server.IntervalTypeImplementation;

/**
 * LENGTH returns the length of the interval value in the argument
 * 
 * @author Erwin
 */
public final class LENGTH_LONGINTERVAL implements OperatorImplementation_V0104 {

	/**
	 * Comment for <code>argumentTypes</code>
	 */
	private static final String[] argumentTypes = new String[] { "LONGINTERVAL" }; //$NON-NLS-1$

	/**
	 * LENGTH returns the length of the interval value in the argument
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ByteBuffer bb1 = ((ScalarValueBuffer) args.get(0)).getByteBuffer();
		bb1.rewind();
		long b = bb1.getLong();
		short inf = bb1.getShort();
		long e = bb1.getLong();
		if (IntervalTypeImplementation.isPositiveInfinite(inf) || IntervalTypeImplementation.isNegativeInfinite(inf)) {
			throw new IllegalArgumentException(Messages.getString("LENGTH_INTINTERVAL.Infinite")); //$NON-NLS-1$
		} else {
			return DbmsLongImplementation.getValueBuffer(e - b);
		}
	}

	/**
	 * LENGTH takes a single operand of type LONGINTERVAL
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
