/**
 * 
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

/**
 * @author Erwin
 * 
 */
public final class LessOrEqualOperatorImplementation implements OperatorImplementation_V0104 {

	/**
	 * The implementation object for the ordering operator (GT) corresponding to this less-than operator
	 */
	private OperatorImplementation greaterThanOperatorImplementation;

	/**
	 * Creates the LessOrEqualOperatorImplementation
	 * 
	 * @param operatorImplementation
	 *            The implementation object for the ordering operator (GT) corresponding to this less-than operator
	 */
	public LessOrEqualOperatorImplementation (OperatorImplementation operatorImplementation) {
		this.greaterThanOperatorImplementation = operatorImplementation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#executeOperator(java.util.LinkedList)
	 */
	@Override
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsBooleanImplementation.getNegatedJavaBooleanBuffer((ScalarValueBuffer) greaterThanOperatorImplementation.executeOperator(args));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#getArgumentTypeNames()
	 */
	@Override
	public String[] getArgumentTypeNames ( ) {
		return greaterThanOperatorImplementation.getArgumentTypeNames();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#getReturnTypeName()
	 */
	@Override
	public String getReturnTypeName ( ) {
		return greaterThanOperatorImplementation.getReturnTypeName();
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
