/**
 * 
 */
package be.SIRAPRISE.typeimplementations;

import java.util.Arrays;
import java.util.LinkedList;

/**
 * LessThanOperatorImplementation is a generic implementation implementing the behaviour of a LT operator, for all types for which an ordering is defined in the form of a GT operator. It operates by invoking the GT operator implementation of the type with the arguments reversed.
 * 
 * @author Erwin
 */
public final class LessThanOperatorImplementation implements OperatorImplementation_V0104 {

	/**
	 * The implementation object for the ordering operator (GT) corresponding to this less-than operator
	 */
	private OperatorImplementation greaterThanOperatorImplementation;

	/**
	 * Creates the LessThanOperatorImplementation
	 * 
	 * @param operatorImplementation
	 *            The implementation object for the ordering operator (GT) corresponding to this less-than operator
	 */
	public LessThanOperatorImplementation (OperatorImplementation operatorImplementation) {
		this.greaterThanOperatorImplementation = operatorImplementation;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#executeOperator(java.util.LinkedList)
	 */
	@Override
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return greaterThanOperatorImplementation.executeOperator(new LinkedList<ValueBuffer>(Arrays.asList(new ValueBuffer[] { args.get(1), args.get(0) })));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#getArgumentTypeNames()
	 */
	@Override
	public String[] getArgumentTypeNames ( ) {
		return greaterThanOperatorImplementation.getArgumentTypeNames();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation#getReturnTypeName()
	 */
	@Override
	public String getReturnTypeName ( ) {
		return greaterThanOperatorImplementation.getReturnTypeName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return greaterThanOperatorImplementation instanceof OperatorImplementation_V0104 ? ((OperatorImplementation_V0104) greaterThanOperatorImplementation).isDeterministic() : true;
	}
}
