/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;
import java.util.regex.Pattern;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * MATCHES returns a boolean indicating whether the first argument matches the pattern string given as the second argument. "Matching" means the same thing as Java's regex matching.
 * 
 * @author Erwin
 */
public final class MATCHES_STRING_STRING implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.STRING, TYPENAMES.STRING };

	/**
	 * MATCHES(s,p) returns true if the string s matches the regular expression p
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return Pattern.matches(DbmsStringImplementation.getJavaString((ScalarValueBuffer) args.get(1)), DbmsStringImplementation.getJavaString((ScalarValueBuffer) args.get(0))) ? DbmsBooleanImplementation.trueValue : DbmsBooleanImplementation.falseValue;
	}

	/**
	 * The return type is BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/**
	 * MATCHES takes two arguments, both of type STRING
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}