/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The INT maximumof operator.
 * 
 * @author Erwin
 */
public final class MAX_INT_INT implements AggregationOperatorImplementation {

	/**
	 * Comment for <code>argumentTypes</code>
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsIntImplementation.getValueBuffer(Integer.MIN_VALUE);

	/**
	 * MAX returns the highest of the two given argument values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsIntImplementation.getValueBuffer(Math.max(DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0)), DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1))));
	}

	/**
	 * MAX takes two arguments, both of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is the lowest possible INT value, -2<sup>31</sup>
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
