/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The LONG maximumof() operator.
 * 
 * @author Erwin
 */
public final class MAX_LONG_LONG implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG, TYPENAMES.LONG };

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsLongImplementation.getValueBuffer(Long.MIN_VALUE);

	/**
	 * MAX returns the highest of the two given argument values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsLongImplementation.getValueBuffer(Math.max(DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(0)), DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(1))));
	}

	/**
	 * MAX takes two arguments, both of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is the lowest possible LONG value, -2<sup>63</sup>
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
