/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The TIMEOFDAY 'maximumof' operator.
 * 
 * @author Erwin
 */
public final class MAX_TIMEOFDAY_TIMEOFDAY implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.TIMEOFDAY, TYPENAMES.TIMEOFDAY };

	/**
	 * The identity element
	 */
	private static final ScalarValueBuffer identity = DbmsTimeofdayImplementation.getValueBuffer(0, 0, 0, 0);

	/**
	 * MAX returns the highest of the two given TIMEOFDAY values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ScalarValueBuffer valueBuffer1 = (ScalarValueBuffer) args.get(0);
		ScalarValueBuffer valueBuffer2 = (ScalarValueBuffer) args.get(1);
		return DbmsLongImplementation.getJavaLong(valueBuffer1) > DbmsLongImplementation.getJavaLong(valueBuffer2) ? valueBuffer1 : valueBuffer2;
	}

	/**
	 * MAX takes two arguments, both of type TIMEOFDAY
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is the lowest possible TIMEOFDAY value, 00:00:00.000000000
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is TIMEOFDAY
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.TIMEOFDAY;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
