/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The DATE 'minimumof' operator.
 * 
 * @author Erwin
 */
public final class MIN_DATE_DATE implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.DATE, TYPENAMES.DATE };

	/**
	 * The identity element
	 */
	private static final ScalarValueBuffer identity = DbmsDateImplementation.getValueBuffer(9999, 12, 31);

	/**
	 * MIN returns the lowest of the two given DATE values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ScalarValueBuffer date1_valueBuffer = (ScalarValueBuffer) args.get(0);
		ScalarValueBuffer date2_valueBuffer = (ScalarValueBuffer) args.get(1);
		return DbmsIntImplementation.getJavaInt(date1_valueBuffer) < DbmsIntImplementation.getJavaInt(date2_valueBuffer) ? date1_valueBuffer : date2_valueBuffer;
	}

	/**
	 * MIN takes two arguments, both of type DATE
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is the highest possible DATE value, 9999-12-31.
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is DATE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.DATE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
