/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The FLOAT 'minimumof' operator.
 * 
 * @author Erwin
 */
public final class MIN_FLOAT_FLOAT implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT, TYPENAMES.FLOAT };

	/**
	 * MIN returns the lowest of the two given argument values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsFloatImplementation.getValueBuffer(Math.min(DbmsFloatImplementation.getJavaDouble(args.get(0)), DbmsFloatImplementation.getJavaDouble(args.get(1))));
	}

	/**
	 * MIN takes two arguments, both of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is the highest possible FLOAT value, 1.7976931348623157e+308
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return DbmsFloatImplementation.getValueBuffer(Double.MAX_VALUE);
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
