/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The INT 'minimumof' operator.
 * 
 * @author Erwin
 */
public final class MIN_INT_INT implements AggregationOperatorImplementation {

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsIntImplementation.getValueBuffer(Integer.MAX_VALUE);

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * MIN returns the lowest of the two given argument values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsIntImplementation.getValueBuffer(Math.min(DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0)), DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1))));
	}

	/**
	 * MIN takes two arguments, both of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is the highest possible INT value, 2<sup>31</sup>-1
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
