/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * MOD(a,b) returns the number c such that a = (a / b) + c.
 * 
 * @author Erwin
 */
public final class MOD_LONG_LONG implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG, TYPENAMES.LONG };

	/**
	 * MOD(a,b) returns the number c such that a = (a / b) + c.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsLongImplementation.getValueBuffer(DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(0)) % DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(1)));
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/**
	 * MOD() takes two arguments, both of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
