/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The FLOAT multiplication operator.
 * 
 * @author Erwin
 */
public final class MULT_FLOAT_FLOAT implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT, TYPENAMES.FLOAT };

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsFloatImplementation.getValueBuffer(1);

	/**
	 * MULT returns the arithmetic product of its argument values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsFloatImplementation.getValueBuffer(DbmsFloatImplementation.getJavaDouble(args.get(0)) * DbmsFloatImplementation.getJavaDouble(args.get(1)));
	}

	/**
	 * MULT takes two arguments, each of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is 1.0
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
