/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The INT multiplication operator.
 * 
 * @author Erwin
 */
public final class MULT_INT_INT implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * MULT returns the arithmetic product of its two argument values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ScalarValueBuffer arg0 = (ScalarValueBuffer) args.get(0);
		ScalarValueBuffer arg1 = (ScalarValueBuffer) args.get(1);
		long b1 = DbmsIntImplementation.getJavaInt(arg0);
		long b2 = DbmsIntImplementation.getJavaInt(arg1);
		long product = b1 * b2;
		if (product > Integer.MAX_VALUE || product < Integer.MIN_VALUE) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("MULT_INT_INT.Overflow"), new Object[] { arg0, arg1 })); //$NON-NLS-1$
		} else {
			return DbmsIntImplementation.getValueBuffer(((int) (product)));
		}
	}

	/**
	 * MULT takes two arguments, both of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is 1
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return DbmsIntImplementation.getValueBuffer(1);
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
