/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The LONG multiplication operator.
 * 
 * @author Erwin
 */
public final class MULT_LONG_LONG implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG, TYPENAMES.LONG };

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsLongImplementation.getValueBuffer(1);

	/**
	 * MULT returns the arithmetic product of its two argument values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ScalarValueBuffer arg0 = (ScalarValueBuffer) args.get(0);
		ScalarValueBuffer arg1 = (ScalarValueBuffer) args.get(1);
		long b1 = DbmsLongImplementation.getJavaLong(arg0);
		long b2 = DbmsLongImplementation.getJavaLong(arg1);
		boolean negativeResult = false;
		if ((b1 < 0 && b2 > 0) || b1 > 0 && b2 < 0) {
			negativeResult = true;
			if (b2 < 0) {
				b2 = -b2;
			} else {
				b1 = -b1;
			}
			long maxMultiplier = Long.MAX_VALUE / b1;
			if (b2 > maxMultiplier) {
				throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("MULT_LONG_LONG.Overflow"), new String[] { DbmsLongImplementation.getExternalRepresentation(arg0), DbmsLongImplementation.getExternalRepresentation(arg1) })); //$NON-NLS-1$
			}
		}
		long product = b1 * b2;
		return negativeResult ? DbmsLongImplementation.getValueBuffer(-product) : DbmsLongImplementation.getValueBuffer(product);
	}

	/**
	 * MULT takes two arguments, each of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is 1
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
