/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The NEXTINT(INT) operator returns the INT value that is one higher than the argument value. If the argument value is the highest possible INT value, then an IllegalArgumentException is thrown.
 * 
 * @author Erwin
 */
public final class NEXTINT_INT implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.INT };

	/**
	 * The NEXTINT(INT) operator returns the INT value that is one higher than the argument value. If the argument value is the highest possible INT value, then an IllegalArgumentException is thrown.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		int i = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0));
		if (i == Integer.MAX_VALUE) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("PLUS_INT_INT.Overflow"), new String[] {})); //$NON-NLS-1$
		}
		return DbmsIntImplementation.getValueBuffer((i + 1));
	}

	/**
	 * NEXTINT() takes a single argument of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
