/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The NEXTLONG(LONG) operator returns the LONG value that is one higher than the argument value. If the argument value is the highest possible LONG value, then an IllegalArgumentException is thrown.
 * 
 * @author Erwin
 */
public final class NEXTLONG_LONG implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.LONG };

	/**
	 * The NEXTLONG(LONG) operator returns the LONG value that is one higher than the argument value. If the argument value is the highest possible LONG value, then an IllegalArgumentException is thrown.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		long i = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(0));
		if (i == Long.MAX_VALUE) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("PLUS_LONG_LONG.Overflow"), new String[] { Long.toString(Long.MAX_VALUE), "1" })); //$NON-NLS-1$ //$NON-NLS-2$
		}
		return DbmsLongImplementation.getValueBuffer(i + 1);
	}

	/**
	 * NEXTLONG() takes a single argument of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
