/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The boolean NOT operator
 * 
 * @author Erwin
 */
public final class NOT_BOOLEAN implements OperatorImplementation_V0104 {

	/**
	 * Comment for <code>argumentTypes</code>
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.BOOLEAN };

	/**
	 * NOT returns true if the argument is false and false if the argument is true
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		if (DbmsBooleanImplementation.getJavaBoolean((ScalarValueBuffer) args.get(0))) {
			return DbmsBooleanImplementation.falseValue;
		} else {
			return DbmsBooleanImplementation.trueValue;
		}
	}

	/**
	 * The argument is of type BOOLEAN
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is BOOLEAN
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
