/*
 * Created on 7-jun-04
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

/**
 * Defines the methods that the implementation class for a sira_prise operator must provide. The implementation class for an operator must be the name of the operator, followed by the type names of the respective arguments, with all those names separated by a single underscore '_'. E.g. the implementation class for an exponentiation operator EXP that takes two arguments of type FLOAT, must be named EXP_FLOAT_FLOAT.
 * 
 * @author Erwin Smout
 */
public interface OperatorImplementation {

	/**
	 * Performs the actual logic of the operator.
	 * 
	 * @param args
	 *            the argument list. The list must hold as many ValueBuffer objects as there are arguments to the operator, and each ValueBuffer object holds a value for some argument to the operator. ValueBuffer objects on the list must appear in the same order as the operator argument declarations.
	 * @return A ValueBuffer object holding the result value of the operator execution in internal format.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args);

	/**
	 * Gets the list of names of types of the needed argument values
	 * 
	 * @return The names of the argument types
	 */
	public String[] getArgumentTypeNames ( );

	/**
	 * Gets the name of the type of the return value
	 * 
	 * @return the name of the type of the return value
	 */
	public String getReturnTypeName ( );
}
