/*
 * Created on 7-jun-04
 */
package be.SIRAPRISE.typeimplementations;

/**
 * Defines the methods that the implementation class for a sira_prise operator must provide. The implementation class for an operator must be the name of the operator, followed by the type names of the respective arguments, with all those names separated by a single underscore '_'. E.g. the implementation class for an exponentiation operator EXP that takes two arguments of type FLOAT, must be named EXP_FLOAT_FLOAT.
 * 
 * @author Erwin Smout
 */
public interface OperatorImplementation_V0104 extends OperatorImplementation {

	/**
	 * Tells whether the operator is deterministic with respect to the arguments of its invocations. An operator is deterministic if and only if for any two distinct invocations, if all the argument values are the same, then the result value returned will also be the same. An example of a nondeterministic operators is RANDOM().
	 * 
	 * @return true if the operator is deterministic.
	 */
	public boolean isDeterministic ( );
}
