/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The PI operator returns the FLOAT constant 3.1415926535...
 * 
 * @author Erwin
 */
public final class PI implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] {};

	/**
	 * 
	 */
	private static final ScalarValueBuffer PI = DbmsFloatImplementation.getValueBuffer(Math.PI);

	/**
	 * The operator returns the FLOAT constant 3.1415926535...
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return PI;
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/**
	 * The operator takes no arguments
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
