/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The AVERAGE addition operator.
 * 
 * @author Erwin
 */
public final class PLUS_AVERAGE_AVERAGE implements AggregationOperatorImplementation {

	/**
	 * Mathematically, every value with a zero observation count is an identity element, except then with respect to itself, in which case we would get a division-by-zero. Nevertheless, we choose the value 0.0 as being the one that would most obviously appear here.
	 */
	private static final ValueBuffer identity = DbmsAverageImplementation.getAverageValueBufferWithoutException(0, 0.0);

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.AVERAGE, TYPENAMES.AVERAGE };

	/**
	 * The average addition operator returns the AVERAGE value (VALUE((c1 * b1) + (c2 * b2) / (c1 + c2)))COUNT(c1 + c2))
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ByteBuffer arg0ByteBuffer = ((ScalarValueBuffer) args.get(0)).getByteBuffer();
		int c1 = arg0ByteBuffer.getInt();
		double b1 = arg0ByteBuffer.getDouble();
		ByteBuffer arg1ByteBuffer = ((ScalarValueBuffer) args.get(1)).getByteBuffer();
		int c2 = arg1ByteBuffer.getInt();
		double b2 = arg1ByteBuffer.getDouble();

		// (c1 * b1) + (c2 * b2) / (c1 + c2)
		// = (b1 * (c1 / (c1 + c2)) + b2 * (c2 / (c1 + c2))

		int count = c1 + c2;
		double dcount = count;
		double value = b1 * (c1 / dcount) + b2 * (c2 / dcount);
		return DbmsAverageImplementation.getAverageValueBuffer(count, value);
	}

	/**
	 * PLUS takes two arguments, both of type AVERAGE
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is the AVERAGE value with COUNT 0 and VALUE 0.0
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return (ScalarValueBuffer) identity;
	}

	/**
	 * The return type is AVERAGE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.AVERAGE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}