/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * PLUS returns the result obtained by adding both operands together
 * 
 * @author Erwin
 * @deprecated The use of this type is discouraged. The definition is rather awkward, the implementation rather poor, and the set of provided operators incomplete.
 */
public final class PLUS_DECIMAL_DECIMAL implements AggregationOperatorImplementation {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.DECIMAL, TYPENAMES.DECIMAL };

	/**
	 * The identity element.
	 */
	private static final ScalarValueBuffer identityElement = new ScalarValueBuffer(ByteBuffer.allocate(10).putLong(0L).put((byte) 0).put((byte) 0));

	/**
	 * PLUS returns the result obtained by adding both operands together
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ByteBuffer byteBuffer1 = ((ScalarValueBuffer) args.get(0)).getByteBuffer();
		ByteBuffer byteBuffer2 = ((ScalarValueBuffer) args.get(1)).getByteBuffer();
		long decimal1 = byteBuffer1.getLong();
		int digits1 = byteBuffer1.get();
		int decimals1 = byteBuffer1.get();
		long decimal2 = byteBuffer2.getLong();
		int digits2 = byteBuffer2.get();
		int decimals2 = byteBuffer2.get();

		long lowerdecimal;
		int lowerdigits;
		int lowerdecimals;
		long higherdecimal;
		int higherdecimals;
		int higherdigits;
		if (decimals1 < decimals2) {
			lowerdecimal = decimal1;
			lowerdigits = digits1;
			lowerdecimals = decimals1;
			higherdecimal = decimal2;
			higherdigits = digits2;
			higherdecimals = decimals2;
		} else {
			lowerdecimal = decimal2;
			lowerdigits = digits2;
			lowerdecimals = decimals2;
			higherdecimal = decimal1;
			higherdigits = digits1;
			higherdecimals = decimals1;
		}
		boolean equalsigns = (lowerdecimal < 0 && higherdecimal < 0) || (lowerdecimal >= 0 && higherdecimal >= 0);

		while (lowerdecimals < higherdecimals && lowerdigits + lowerdecimals <= 17) {
			lowerdecimal *= 10;
			lowerdecimals++;
		}
		boolean decimalslost = false;
		long savedhigherdecimal = 0;
		long savedlowerdecimal = 0;
		while (lowerdecimals < higherdecimals) {
			if (higherdecimals == lowerdecimals + 1) {
				decimalslost = true;
				savedhigherdecimal = higherdecimal;
				savedlowerdecimal = lowerdecimal * 10;
			}
			higherdecimal /= 10;
			higherdecimals--;
		}

		// Reduce to 17 digits if there are any decimals left and the total number of digits in any of the arguments exceeds 17
		if (equalsigns && lowerdecimals > 0 && (lowerdigits + lowerdecimals == 18 || higherdigits + higherdecimals == 18)) {
			decimalslost = true;
			savedhigherdecimal = higherdecimal;
			higherdecimal /= 10;
			higherdecimals--;
			savedlowerdecimal = lowerdecimal;
			lowerdecimal /= 10;
			lowerdecimals--;
		}

		long sumdecimal = lowerdecimal + higherdecimal;
		long abssumdecimal = Math.abs(sumdecimal);
		// Test if an extra digit has been generated
		// (129,2,1) + (1000,3,1) = (1129,3,1)
		// (999,2,1) + (999,2,1) = (1998,3,1)
		// (9999,3,1) + (999,2,1) = (10998,4,1)
		// ===> Take the sum of the decimals and the highest value of digts1, digits2
		// Take that power of 10
		// Verify the result divided by that power. 0 == no extra digit obtained, 1 = extra digit indeed obtained.
		int totaldigits = lowerdecimals + Math.max(lowerdigits, higherdigits);

		ByteBuffer resultBuffer = ByteBuffer.allocate(10);

		int resultdigits;
		if (equalsigns) {
			long extradigit = abssumdecimal / DbmsDecimalImplementation.powers_l[totaldigits];

			if (totaldigits + extradigit > 18) {
				throw new NumericOverflowException();
			}

			// If decimals were lost and we did not obtain an extra digit, re-compute
			if (decimalslost && extradigit == 0) {
				lowerdecimal = savedlowerdecimal;
				lowerdecimals++;
				higherdecimal = savedhigherdecimal;
				higherdecimals++;
				sumdecimal = lowerdecimal + higherdecimal;
			}

			resultdigits = (int) (extradigit + Math.max(lowerdigits, higherdigits));
		} else {
			while (totaldigits > lowerdecimals && abssumdecimal / DbmsDecimalImplementation.powers_l[totaldigits - 1] == 0) {
				totaldigits--;
			}

			resultdigits = totaldigits - lowerdecimals;
		}

		while (lowerdecimals > 0 && sumdecimal % 10 == 0) {
			sumdecimal /= 10;
			lowerdecimals--;
		}
		resultBuffer.putLong(sumdecimal);
		resultBuffer.put((byte) resultdigits);
		resultBuffer.put((byte) lowerdecimals);

		return new ScalarValueBuffer(resultBuffer);
	}

	/**
	 * DECIMAL addition takes two operands, both of type DECIMAL
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value for PLUS is 0
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identityElement;
	}

	/**
	 * The return type is DECIMAL
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.DECIMAL;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
