/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The FLOAT addition operator.
 * 
 * @author Erwin
 */
public final class PLUS_FLOAT_FLOAT implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT, TYPENAMES.FLOAT };

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsFloatImplementation.getValueBuffer(0);

	/**
	 * PLUS returns the sum of the two given arguments.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsFloatImplementation.getValueBuffer(DbmsFloatImplementation.getJavaDouble(args.get(0)) + DbmsFloatImplementation.getJavaDouble(args.get(1)));
	}

	/**
	 * PLUS takes two arguments, each of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value for PLUS is FLOAT(0.0)
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
