/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The PLUS(INT,INT) operator returns the INT value that is the sum of the two arguments. If no such value exists (overflow condition), then an IllegalArgumentException is thrown.
 * 
 * @author Erwin
 */
public final class PLUS_INT_INT implements AggregationOperatorImplementation {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsIntImplementation.getValueBuffer(0);

	/**
	 * The PLUS(INT,INT) operator returns the INT value that is the sum of the two arguments. If no such value exists (overflow condition), then an IllegalArgumentException is thrown.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		long sum = (long) DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0)) + (long) DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1));
		if (sum > Integer.MAX_VALUE || sum < Integer.MIN_VALUE) {
			throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("PLUS_INT_INT.Overflow"), new String[] {})); //$NON-NLS-1$
		} else {
			return DbmsIntImplementation.getValueBuffer(((int) (sum)));
		}
	}

	/**
	 * PLUS takes two arguments, each of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value for PLUS is INT(0)
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
