/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The PLUS(LONG,LONG) operator returns the LONG value that is the sum of the two arguments. If no such value exists (overflow condition), then an IllegalArgumentException is thrown.
 * 
 * @author Erwin
 */
public final class PLUS_LONG_LONG implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG, TYPENAMES.LONG };

	/**
	 * 
	 */
	private static final ScalarValueBuffer identity = DbmsLongImplementation.getValueBuffer(0);

	/**
	 * The PLUS(LONG,LONG) operator returns the LONG value that is the sum of the two arguments. If no such value exists (overflow condition), then an IllegalArgumentException is thrown.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ScalarValueBuffer arg0 = (ScalarValueBuffer) args.get(0);
		ScalarValueBuffer arg1 = (ScalarValueBuffer) args.get(1);
		long b1 = DbmsLongImplementation.getJavaLong(arg0);
		long b2 = DbmsLongImplementation.getJavaLong(arg1);
		boolean switchSign = false;
		if ((b1 > 0 && b2 > 0) || (b1 < 0 && b2 < 0)) {
			if (b1 < 0) {
				switchSign = true;
				b1 = -b1;
				b2 = -b2;
			}
			long maxAddendum = Long.MAX_VALUE - b1;
			if (b2 > maxAddendum) {
				throw new IllegalArgumentException(MyMessageFormat.format(Messages.getString("PLUS_LONG_LONG.Overflow"), new String[] { DbmsLongImplementation.getExternalRepresentation(arg0), DbmsLongImplementation.getExternalRepresentation(arg1) })); //$NON-NLS-1$
			}
		}

		return switchSign ? DbmsLongImplementation.getValueBuffer(-b1 - b2) : DbmsLongImplementation.getValueBuffer(b1 + b2);
	}

	/**
	 * PLUS takes two arguments, each of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value for PLUS is LONG(0)
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is LONG
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.LONG;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
