/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The TIMEOFDAY addition operator.
 * 
 * @author Erwin
 */
public final class PLUS_TIMEOFDAY_TIMEOFDAY implements AggregationOperatorImplementation {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.TIMEOFDAY, TYPENAMES.TIMEOFDAY };

	/**
	 * The identity element
	 */
	private static final ScalarValueBuffer identity = DbmsTimeofdayImplementation.getValueBuffer(0, 0, 0, 0);

	/**
	 * PLUS returns the sum of the two given TIMEOFDAY values
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ScalarValueBuffer valueBuffer1 = (ScalarValueBuffer) args.get(0);
		long v1 = DbmsLongImplementation.getJavaLong(valueBuffer1);
		int nanoSeconds1 = DbmsTimeofdayImplementation.getNanoSeconds(v1);
		int seconds1 = DbmsTimeofdayImplementation.getSeconds(v1);
		int minutes1 = DbmsTimeofdayImplementation.getMinutes(v1);
		int hours1 = DbmsTimeofdayImplementation.getHours(v1);
		ScalarValueBuffer valueBuffer2 = (ScalarValueBuffer) args.get(1);
		long v2 = DbmsLongImplementation.getJavaLong(valueBuffer2);
		int nanoSeconds2 = DbmsTimeofdayImplementation.getNanoSeconds(v2);
		int seconds2 = DbmsTimeofdayImplementation.getSeconds(v2);
		int minutes2 = DbmsTimeofdayImplementation.getMinutes(v2);
		int hours2 = DbmsTimeofdayImplementation.getHours(v2);
		int rnanoseconds = nanoSeconds1 + nanoSeconds2;
		int cseconds = 0;
		if (rnanoseconds > DbmsTimeofdayImplementation.MAX_NANOSECONDS) {
			cseconds = 1;
			rnanoseconds -= (DbmsTimeofdayImplementation.MAX_NANOSECONDS + 1);
		}
		int rseconds = seconds1 + seconds2 + cseconds;
		int cminutes = 0;
		if (rseconds > DbmsTimeofdayImplementation.MAX_SECONDS) {
			cminutes = 1;
			rseconds -= (DbmsTimeofdayImplementation.MAX_SECONDS + 1);
		}
		int rminutes = minutes1 + minutes2 + cminutes;
		int chours = 0;
		if (rminutes > DbmsTimeofdayImplementation.MAX_MINUTES) {
			chours = 1;
			rminutes -= (DbmsTimeofdayImplementation.MAX_MINUTES + 1);
		}
		int rhours = hours1 + hours2 + chours;
		if (rhours > DbmsTimeofdayImplementation.MAX_HOURS) {
			rhours -= (DbmsTimeofdayImplementation.MAX_HOURS + 1);
		}
		return DbmsTimeofdayImplementation.getValueBuffer(rhours, rminutes, rseconds, rnanoseconds);
	}

	/**
	 * PLUS takes two arguments, each of type TIMEOFDAY
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The identity value is 0:0:0.0
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return identity;
	}

	/**
	 * The return type is TIMEOFDAY
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.TIMEOFDAY;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
