/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.Calendar;

import java.util.GregorianCalendar;
import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The PRIORDATE(DATE) operator returns the DATE value that is one day before the argument value. If the argument value is the lowest possible DATE value, then an IllegalArgumentException is thrown.
 * 
 * @author Erwin
 */
public final class PRIORDATE_DATE implements OperatorImplementation_V0104 {

	/**
	 * The argument types
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.DATE };

	/**
	 * The PRIORDATE(DATE) operator returns the DATE value that is one day before the argument value. If the argument value is the lowest possible DATE value, then an IllegalArgumentException is thrown.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		int date = DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0));
		if (date == 1 + 32 * (1 + 12 * 1)) {
			throw new IllegalArgumentException(Messages.getString("PRIORDATE_DATE.BC")); //$NON-NLS-1$
		}

		int dd = date & 0x0000001f;
		date = date >> 5;
		int mm = date % 12; // mm is as in Java, i.e. January=0, Novermber=10. Comprehend who can ...
		int yyyy = date / 12;

		if (dd == 1 && mm == 0 && yyyy == 1) {
			throw new IllegalArgumentException(Messages.getString("DbmsDateImplementation.BC")); //$NON-NLS-1$
		}
		
		GregorianCalendar gregorianDate = new GregorianCalendar(yyyy, mm, dd);
		gregorianDate.add(Calendar.DAY_OF_MONTH, -1);
		dd = gregorianDate.get(Calendar.DAY_OF_MONTH);
		mm = gregorianDate.get(Calendar.MONTH);
		yyyy = gregorianDate.get(Calendar.YEAR);

		return DbmsDateImplementation.getValueBuffer(yyyy, mm + 1, dd);
	}

	/**
	 * PRIORDATE takes a single argument of type DATE
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is of type DATE
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.DATE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
