/*
 * Created on 29-sep-2005
 */
package be.SIRAPRISE.typeimplementations;

/**
 * Defines the methods that the implementation class for a SIRA_PRISE PossRep must provide.
 * 
 * This interface replaces PossRepImplementation.  The old getComponentValue() method, which took a ScalarValueBuffer specifically, is now superseded by a like-named method that can act on any ValueBuffer.
 * 
 * @author Erwin Smout
 */
public interface PossRepImplementation14 extends PossRepImplementation {

	/**
	 * "Extracts" a possrep component value out of a value of the type
	 * 
	 * @param componentName
	 *            The possrep component Name
	 * @param valueBuffer
	 *            The scalarValueBuffer holding the value of which the possrep's component's value is to be extracted
	 * @return The value of the component in this possrep's representation of the given value
	 */
	public ValueBuffer getComponentValue (String componentName, ValueBuffer valueBuffer);

}