/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The float rounding operator returns the FLOAT value that is an exact multiple of the second argument (the rounding unit), and for which the absolute value of the difference with the first argument (the number to be rounded) is minimal.
 * 
 * @author Erwin
 */
public final class ROUND_FLOAT_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT, TYPENAMES.FLOAT };

	/**
	 * The float rounding operator returns the FLOAT value that is an exact multiple of the second argument (the rounding unit), and for which the absolute value of the difference with the first argument (the number to be rounded) is minimal.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ValueBuffer numberBuffer = args.get(0);
		double number = DbmsFloatImplementation.getJavaDouble(numberBuffer);
		double absoluteValue = Math.abs(number);
		double roundingUnit = Math.abs(DbmsFloatImplementation.getJavaDouble(args.get(1)));
		if (absoluteValue + roundingUnit == absoluteValue) { // rounding unit below precision of number
			return numberBuffer;
		}

		return DbmsFloatImplementation.getValueBuffer((((long) (absoluteValue / (roundingUnit / 2.0)) - 1) / 2 + 1) * roundingUnit * (number < 0 ? -1 : 1));
	}

	/**
	 * ROUND takes two arguments, each of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
