/*
 * Created on 14-mei-2007
 */
package be.SIRAPRISE.typeimplementations;


import be.SIRAPRISE.client.AbstractRelation;
import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.SIRAPRISE.server.DbmsRelationImplementation;

/**
 * A RelationBuffer is the ValueBuffer type for relation values.
 * 
 * @author Erwin Smout
 */
public final class RelationBuffer extends ValueBuffer {

	/**
	 * The relation value held
	 */
	private AbstractRelation relation;

	/**
	 * Creates the buffer and sets its value
	 * 
	 * @param relation
	 *            The value to be held in this buffer
	 */
	public RelationBuffer (AbstractRelation relation) {
		this.relation = relation;
	}

	public boolean equals (Object obj) {
		return (obj instanceof RelationBuffer) && relation.equals(((RelationBuffer) obj).getRelation());
	}

	/**
	 * Gets the relation value
	 * 
	 * @return The relation value
	 */
	public AbstractRelation getRelation ( ) {
		return relation;
	}

	public int hashCode ( ) {
		return relation.hashCode();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString ( ) {
		return TYPENAMES.RELATION + '(' + DbmsRelationImplementation.getInstance().valueToExternalRepresentation(this) + ')';
	}
}