/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The ANGLE secant operator.
 * 
 * @author Erwin
 */
public final class SEC_ANGLE implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.ANGLE };

	/**
	 * SECANT returns the secant, i.e. the reciprocal of the cosine, of the angle given as argument value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsFloatImplementation.getValueBuffer(1.0 / Math.cos(DbmsAngleImplementation.getJavaDouble((ScalarValueBuffer) args.get(0))));
	}

	/**
	 * SECANT takes a single argument of type ANGLE
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
