/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The FLOAT square root operator.
 * 
 * @author Erwin
 */
public final class SQRT_FLOAT implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.FLOAT };

	/**
	 * SQRT returns the square root of the given FLOAT value
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return DbmsFloatImplementation.getValueBuffer(Math.sqrt(DbmsFloatImplementation.getJavaDouble(args.get(0))));
	}

	/**
	 * SQRT takes a single argument of type FLOAT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is FLOAT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.FLOAT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
