/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The String Substring operator.
 * 
 * @author Erwin
 */
public final class SUBSTR_STRING_INT implements OperatorImplementation_V0104 {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.STRING, TYPENAMES.INT };

	/**
	 * SUBSTR(s,i) returns the string that appears in s starting at position i. i is in the range [1-(LENGTH(s)+1)]. It will be adjusted to meet that condition if it is outside that range. SUBSTR(s,1) returns s.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		String s = DbmsStringImplementation.getJavaString(((ScalarValueBuffer) args.get(0)));
		try {
			return DbmsStringImplementation.getValueBuffer(s.substring(Math.min(s.length(), Math.max(0, DbmsIntImplementation.getJavaInt(((ScalarValueBuffer) args.get(1))) - 1))));
		} catch (InvalidValueException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * SUBSTR takes an argument of type STRING plus one of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is STRING
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.STRING;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
