/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The String Substring operator.
 * 
 * @author Erwin
 */
public final class SUBSTR_STRING_INT_INT implements OperatorImplementation_V0104 {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.STRING, TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * SUBSTR(s,i,j) returns the string that appears in s starting at position i, and ends at the position immeidately before j. i is in the range [1-(LENGTH(s)+1)]. j is in the range [i-(LENGTH(s)+1)]. Both will be adjusted to meet those conditions if they are outside that range. i will be adjusted before j. The first position is 1. SUBSTR(s,x,x) returns the empty string.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		String s = DbmsStringImplementation.getJavaString(((ScalarValueBuffer) args.get(0)));
		// avoid runtime exceptions by moving i1 to within bounds for the length s has.
		int i11 = Math.min(s.length(), Math.max(0, DbmsIntImplementation.getJavaInt(((ScalarValueBuffer) args.get(1))) - 1));
		// avoid runtime exceptions by moving i2 to within bounds for the length s has.
		int i12 = Math.min(s.length(), Math.max(i11, DbmsIntImplementation.getJavaInt(((ScalarValueBuffer) args.get(2))) - 1));
		try {
			return DbmsStringImplementation.getValueBuffer(s.substring(i11, i12));
		} catch (InvalidValueException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * SUBSTR takes an argument of type STRING plus two arguments of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is STRING
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.STRING;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
