/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;
import be.erwinsmout.MyMessageFormat;

/**
 * The integer subtraction operator.
 * 
 * @author Erwin
 */
public final class SUB_INT_INT implements OperatorImplementation_V0104 {

	/**
	 * Comment for <code>argumentTypes</code>
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.INT, TYPENAMES.INT };

	/**
	 * SUB returns the difference between the first argument (the minuend) and the second (the subrahend)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		long difference = (long) DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(0)) - DbmsIntImplementation.getJavaInt((ScalarValueBuffer) args.get(1));
		if (difference > Integer.MAX_VALUE || difference < Integer.MIN_VALUE) {
			throw new RuntimeException(MyMessageFormat.format(Messages.getString("PLUS_INT_INT.Overflow"), new String[] {})); //$NON-NLS-1$
		} else {
			return DbmsIntImplementation.getValueBuffer(((int) difference));
		}
	}

	/**
	 * SUB takes two arguments, both of type INT
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
