/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The timeofday difference operator. SUB returns the difference between two TIMEOFDAY values as another TIMEOFDAY value. If the subtrahend represents a later time than the minuend (making the result "negative" as it were), then this negative result is incremented by 24 hrs. I.e., the subtrahend is then assumed to represent a time "of the previous day".
 * 
 * @author Erwin
 */
public final class SUB_TIMEOFDAY_TIMEOFDAY implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.TIMEOFDAY, TYPENAMES.TIMEOFDAY };

	/**
	 * SUB returns the difference between two TIMEOFDAY values as another TIMEOFDAY value.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		ScalarValueBuffer valueBuffer1 = (ScalarValueBuffer) args.get(0);
		long v1 = DbmsLongImplementation.getJavaLong(valueBuffer1);
		int nanoSeconds1 = DbmsTimeofdayImplementation.getNanoSeconds(v1);
		int seconds1 = DbmsTimeofdayImplementation.getSeconds(v1);
		int minutes1 = DbmsTimeofdayImplementation.getMinutes(v1);
		int hours1 = DbmsTimeofdayImplementation.getHours(v1);
		ScalarValueBuffer valueBuffer2 = (ScalarValueBuffer) args.get(1);
		long v2 = DbmsLongImplementation.getJavaLong(valueBuffer2);
		int nanoSeconds2 = DbmsTimeofdayImplementation.getNanoSeconds(v2);
		int seconds2 = DbmsTimeofdayImplementation.getSeconds(v2);
		int minutes2 = DbmsTimeofdayImplementation.getMinutes(v2);
		int hours2 = DbmsTimeofdayImplementation.getHours(v2);

		int rnanoseconds = nanoSeconds1 - nanoSeconds2;
		int cseconds = 0;
		if (rnanoseconds < 0) {
			cseconds = -1;
			rnanoseconds += (DbmsTimeofdayImplementation.MAX_NANOSECONDS + 1);
		}
		int rseconds = seconds1 - seconds2 + cseconds;
		int cminutes = 0;
		if (rseconds < 0) {
			cminutes = -1;
			rseconds += (DbmsTimeofdayImplementation.MAX_SECONDS + 1);
		}
		int rminutes = minutes1 - minutes2 + cminutes;
		int chours = 0;
		if (rminutes < 0) {
			chours = -1;
			rminutes += (DbmsTimeofdayImplementation.MAX_MINUTES + 1);
		}
		int rhours = hours1 - hours2 + chours;
		if (rhours < 0) {
			rhours += (DbmsTimeofdayImplementation.MAX_HOURS + 1);
		}
		return DbmsTimeofdayImplementation.getValueBuffer(rhours, rminutes, rseconds, rnanoseconds);
	}

	/**
	 * SUB takes two arguments, both of type TIMEOFDAY
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is TIMEOFDAY
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.TIMEOFDAY;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
