/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;
import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The TOINT operator "casts" a LONG to an INT
 * 
 * @author Erwin
 */
public final class TOINT_LONG implements OperatorImplementation_V0104 {

	/**
	 * The required argument types
	 */
	private static final String[] argumentTypes = new String[] { TYPENAMES.LONG };

	/**
	 * The operator returns the LONG value that represents the same number as the given INT argument.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		long value = DbmsLongImplementation.getJavaLong((ScalarValueBuffer) args.get(0));
		if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
			throw new NumericOverflowException();
		}
		return DbmsLongImplementation.getValueBuffer(value);
	}

	/**
	 * The operator takes a single argument of type LONG
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypes;
	}

	/**
	 * The return type is INT
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.INT;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
