/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * UPPERCASE() returns the input argument, converted to uppercase.
 * 
 * @author Erwin
 */
public final class UPPERCASE_STRING implements OperatorImplementation_V0104 {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.STRING };

	/**
	 * UPPERCASE() returns the input argument, converted to uppercase.
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		try {
			return DbmsStringImplementation.getValueBuffer(DbmsStringImplementation.getJavaString(((ScalarValueBuffer) args.get(0))).toUpperCase());
		} catch (InvalidValueException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * The operator takes a single argument of type STRING
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/**
	 * The return type is STRING
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.STRING;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
