/*
 * Created on 17-okt-2004 by Erwin
 */
package be.SIRAPRISE.typeimplementations;

import java.util.LinkedList;

import be.SIRAPRISE.client.NAMES.TYPENAMES;

/**
 * The implementation for the boolean XOR operator.
 * 
 * @author Erwin
 */
public final class XOR_BOOLEAN_BOOLEAN implements AggregationOperatorImplementation, BinaryBooleanOperatorImplementation {

	/**
	 * The argument type names
	 */
	private static final String[] argumentTypeNames = new String[] { TYPENAMES.BOOLEAN, TYPENAMES.BOOLEAN };

	/**
	 * The instance
	 */
	private static final XOR_BOOLEAN_BOOLEAN instance = new XOR_BOOLEAN_BOOLEAN();

	/**
	 * @return the instance of the implementation
	 */
	public static XOR_BOOLEAN_BOOLEAN getInstance ( ) {
		return instance;
	}

	/**
	 *
	 */
	private XOR_BOOLEAN_BOOLEAN ( ) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.OperatorImplementation#executeOperator(java.util.LinkedList)
	 */
	public ValueBuffer executeOperator (LinkedList<ValueBuffer> args) {
		return (DbmsBooleanImplementation.getJavaBoolean((ScalarValueBuffer) args.get(1)) == DbmsBooleanImplementation.getJavaBoolean((ScalarValueBuffer) args.get(0))) ? DbmsBooleanImplementation.falseValue : DbmsBooleanImplementation.trueValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.OperatorImplementation#getArgumentTypes()
	 */
	public String[] getArgumentTypeNames ( ) {
		return argumentTypeNames;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.SIRA_PRISE.typeimplementations.AssociativeOperatorImplementation#getIdentityElement()
	 */
	public ScalarValueBuffer getIdentityElement ( ) {
		return DbmsBooleanImplementation.falseValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.server.BinaryBooleanOperatorImplementation#getNegated(java.util.LinkedList)
	 */
	public String getNegated (String operand1, String operand2) {
		return "EQ(" + operand1 + "," + operand2 + ")"; //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.erwinsmout.DBMS.TypeImplementations.OperatorImplementation#getReturnType()
	 */
	public String getReturnTypeName ( ) {
		return TYPENAMES.BOOLEAN;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see be.SIRAPRISE.typeimplementations.OperatorImplementation_V0104#isDeterministic()
	 */
	@Override
	public boolean isDeterministic ( ) {
		return true;
	}
}
